<?php
/*
This is a simple demonstration of the basic concepts.
- We have a component responsible for providing access to other components.
- Here we call it component manager, but sometimes it is also called application container, or container in short.
- The implementation here is quite simple and can be improved in a multiple ways.
- It is common that the ComponentManager would also initialize the components.
  For example pass in reference to itself, so the components can use is to get other components.
*/

// Just some interfaces and implementations for us to later.

interface Presenter {}

class CustomerListPresenter implements Presenter {}

interface Router {}

class DefaultRouter implements Router {}

//

interface ComponentManager {

  public function getByName($name);

  public function getByInterface($interface);

}

class DefaultComponentManager implements ComponentManager {

  private $components;

  public function __construct($components) {
    $this->components = $components;
  }

  public function getByName($name) {
    return $this->components[$name];
  }

  public function getByInterface($interface) {
    foreach($this->components as $component) {
      if ($component instanceof $interface) {
        return $component;
      }
    }
  }

}

// Here we provide the components as an argument to the constructor.
// There are better ways to do this.
$componentManager = new DefaultComponentManager([
  'customer-list.presenter' => new CustomerListPresenter(),
  'router' => new DefaultRouter(),
]);

// Test: get implementation of an interface.
$router = $componentManager->getByInterface(Router::class);
var_dump($router);

// Test: get using a name.
$customerList = $componentManager->getByName('customer-list.presenter');
var_dump($customerList);
