<?php
$database = json_decode(file_get_contents(__DIR__ . "/database.json"), true);
session_start();
?><!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>AI & Software</title>
  <link rel="stylesheet" href="style.css">
</head>

<body>
  <header class="flex justify-between align-center" style="padding: 0.75em; border-bottom: 1px solid white;">
    <h1 style="margin: 0">AI & Software</h1>
    <?php if (isset($_SESSION["user"])) { ?>
    <a href="./logout.php">Logout</a>
    <?php } else { ?>
    <a href="./login.php">Login</a>
    <?php } ?>
  </header>
  <main class="flex flex-col align-center">
    <section>
      <h2>Joint the AI revolution ...</h2>
      <p>Welcome to the AI & Software event taking place in the future near you!</p>
    </section>
    <section>
      <h2>Workshops</h2>
      <p>Beside the main event you can attend several workshops.</p>
      <ul>
        <li>AI as a pair programmer</li>
        <li>Leading team of AI agents</li>
        <li>Code no longer matters: On requirements driven software in the age of AI</li>
        <li>AI reasoning with knowledge graphs</li>
      </ul>
    </section>
    <section>
      <h2>Ready to meet awesome people?</h2>
      <p>
        Here are the attendees who registered for the event and agreed to be listed publicly.
      </p>
      <ul>
        <?php foreach ($database['participants'] as $person) { ?>
          <li><?= htmlspecialchars($person['fullName']) ?></li>
        <?php } ?>
      </ul>
    </section>
    <section>
      <h2>Registration</h2>
      <?php if (isset($_SESSION["user"])) { ?>
        <p>
          You are already registered.
        </p>
      <?php } else { ?>
      <p>
        The event is still open for registrations, but it may not be for long.
        You better hurry up and
      </p>
      <form action="./registration.php">
        <button type="submit" style="padding: 10px 20px; cursor: pointer; width: 100%;">
          reserve your spot at the event
        </button>
      </form>
      <?php } ?>
    </section>
    <p>
  </main>
</body>

</html>