<?php
  $fullName = $_GET['full-name'];
  $email = $_GET['email'];
  $public = (int)($_GET['public'] === 'on');
  $workshops = $_GET['workshops'];
?><!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>AI & Software</title>
  <link rel="stylesheet" href="style.css">
</head>

<body style="margin-top: 4ex">

  <main style="max-width: 80ch; margin: 0 auto;">
    <section>
      <h1>Register for AI & Software event</h1>
      <p>
        Thank you for your interest in the AI & Software event.
        Please review the details you have provided to ensure they are correct.
      </p>
    </section>

    <section>
      <p>Full name: <?= htmlspecialchars($fullName) ?></p>
      <p>E-mail: <?= htmlspecialchars($email) ?></p>
      <p>Workshops:</p>
      <ul>
      <?php foreach ($workshops as $workshop) { ?>
        <li><?= htmlspecialchars($workshop) ?></li>
      <?php } ?>
      </ul>
    </section>

    <section>
      <p>
        By confirming your registration, you agree to attend the event and abide by the event guidelines.
      </p>
      <form action="./finish-registration.php" method="post" type="multipart/form-data" class="flex justify-end">
        <input type="hidden" name="fullName" value="<?= $fullName ?>">
        <input type="hidden" name="public" value="<?= $public ?>">
        <input type="hidden" name="email" value="<?= $email ?>">
        <?php foreach ($workshops as $workshop) { ?>
          <input type="hidden" name="workshops[]" value="<?= $workshop ?>">
        <?php } ?>
        <button type="submit" style="padding: 10px 20px; cursor: pointer; width: 100%;">
          Confirm my registration
        </button>
      </form>
    </section>

</body>

</html>