<?php

header('Content-Type: text/html; charset=utf-8');

/* #region model */

define('DATABASE_FILE', __DIR__ . '/database.json');
function loadDatabase($path) {
    if (!is_readable($path)) {
        return [];
    }
    $content = file_get_contents($path);
    return json_decode($content, true);
}

function saveDatabase($path, $data) {
    $content = json_encode($data);
    file_put_contents($path, $content);
}

/* #endregion */

function printHtml($content)  {
    print(htmlspecialchars($content));
}

$data = loadDatabase(DATABASE_FILE);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($_POST['action'] === 'delete') {
        unset($data[$_POST['id']]);
        saveDatabase(DATABASE_FILE, $data);
    } else if ($_POST['action'] === 'add') {
        $data[] = [
            'firstName' => $_POST['firstName'],
            'secondName' => $_POST['secondName'],
            'age' => $_POST['age'],
        ];
        saveDatabase(DATABASE_FILE, $data);
    } else {
        // Ignore other actions.
    }
    // TODO: USe HTTP 302 redirection.
    // header('Location: ?');
    exit;
}

?><!DOCTYPE HTML>
<html lang="en">
<head>
  <title>PHP : POSTing a Form</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>

<body>
<main class="container">
<section>
  <h1>PHP : POSTing a Form</h1>
</section>
<hr>

<section>
  <h2>Existing records</h2>
  <ul>
  <?php foreach ($data as $key => $item) { ?>
  <li>
    <dl>
      <dt>First name</dt>
      <dd><?php printHtml($item['firstName']); ?></dd>
      <dt>Second name</dt>
      <dd><?php printHtml($item['secondName']); ?></dd>
      <dt>Age</dt>
      <dd><?php printHtml($item['age']); ?></dd>
      <form action="?" method="POST">
        <input type="hidden" name="id" value="<?php printHtml($key); ?>"/>
        <button type="submit" name="action" value="delete" class="btn btn-danger">Remove</button>
      </form>
    </dl>
  </li>
  <?php } ?>
  </ul>
</section>

<hr>

<section>
  <h2>Create new record</h2>
  <form action="?" method="POST">
    <p class="mb-3">
      <label class="form-label">
        First name:
        <input type="text" name="firstName" class="form-control"/>
      </label>
    </p>
    <p class="mb-3">
      <label class="form-label">
        Second name:
        <input type="text" name="secondName" class="form-control"/>
      </label>
    </p>
    <p class="mb-3">
      <label class="form-label">
        Age:
        <input type="number" name="age" class="form-control"/>
      </label>
    </p>
    <button type="submit" name="action" value="add" class="btn btn-primary">
      Add
    </button>
  </form>
</section>

</main>
</body>
</html>
