import socket

HOST = "127.0.0.1"
PORT = 8080

HTML_CONTENT = """
<!DOCTYPE html>
<html>
<head>
  <title>Simple HTTP Server</title>
</head>
<body>
  <div>Hello, this is a static HTML content!</div>
</body>
</html>
"""

def handle_request(client_socket):
  request = client_socket.recv(1024).decode("utf-8")
  headers = request.split("\r\n")
  method, path, _ = headers[0].split()
  print(f"Handling {method} for {path}")
  # We need to send back proper response.
  response = "HTTP/1.1 200 OK\r\nContent-Type: text/html\r\n\r\n" + HTML_CONTENT
  client_socket.sendall(response.encode("utf-8"))
  client_socket.close()

def run_server():
  with socket.socket(socket.AF_INET, socket.SOCK_STREAM) as server_socket:
    # Binding socket to IP and PORT.
    server_socket.bind((HOST, PORT))
    server_socket.listen()
    print(f"Serving HTTP on {HOST}:{PORT}")
    # We handle just one request ...
    client_socket, client_address = server_socket.accept()
    handle_request(client_socket)

if __name__ == "__main__":
  run_server()
