const http = require("http");

// Prepare a http server...
const server = http.createServer((request, response) => {
	console.log("Received HTTP request for " + request.url);

	// Prepare response body.
	const body = "This is a response to HTTP request " + request.url;

	// Write headers.
	response.writeHead(200,	// HTTP OK response
		{	// Headers
			"Content-Length": body.length,
			"Content-Type": "text/plain"
		}
	);

	// Send body and terminate.
	response.end(body);
});

// Start up the server.
const port = 3000;
server.listen(port, () => {
	console.log("Starting HTTP server on port " + port + " ...");
});

// Terminate the server on Ctrl+C
function cleanup() {
	console.log("Shutting down...");
	server.close();
	process.exit(0);
}

process.on("SIGTERM", cleanup);
process.on("SIGINT", cleanup);
