const express = require('express');

const app = express();
const port = 3000;

// Middleware to parse JSON
app.use(express.json());

// Home route
app.get('/', (req, res) => {
  res.send('Welcome to the Node.js Express Demo Application!');
});

// Example route
app.get('/api/example', (req, res) => {
  res.json({ message: 'This is an example route.' });
});

// Start the server
app.listen(port, () => {
  console.log(`Server is running on http://localhost:${port}`);
});
