<?php

/**
 * Render the internals of game table.
 */
function render_game($fields, $onMove)
{
  for ($i = 0; $i < 9;) {
    echo tr([
      td(create_field($fields, $i++, $onMove)),
      td(create_field($fields, $i++, $onMove)),
      td(create_field($fields, $i++, $onMove)),
    ]);
  }
}

/**
 * Create a table cell.
 */
function td($content)
{
  return "\t\t<td>\n\t\t\t$content\n\t\t</td>";
}

/**
 * Create a table row.
 */
function tr($content)
{
  $res = ["\t<tr>"];
  if (is_array($content)) {
    $res = array_merge($res, $content);
  } else {
    $res[] = $content;
    $res[] = "\t</tr>\n";
  }
  return join("\n", $res);
}

/**
 * Prepare content of a game field.
 */
function create_field($fields, $i, $onMove)
{
  $value = $fields[$i];
  if (!$value) {
    $fields[$i] = $onMove;
    $url = create_url(['fields' => $fields]);
    return "<a href=\"$url\" class=\"$onMove\"></a>";
  }
  $images = [
    'X' => 'kitten.png',
    'O' => 'duck.png',
  ];
  $url = $images[$value];
  return "<img src=\"$url\">";
}

/**
 * Generates an URL query based on given values.
 * @param $params Parameters to be encoded in URL.
 */
function create_url(array $params = [])
{
  // Assemble the URL and encode for HTML if required.
  $url = '?' . http_build_query($params);
  $url = htmlspecialchars($url, ENT_QUOTES);
  return $url;
}

function get_field_value($index) {
  if (!isset($_GET['fields'])) {
    return '';
  }
  $value = $_GET['fields'][$index];
  if (empty($value) || ($value != 'X' && $value != 'O')) {
    return '';
  } else {
    return $value;
  }
}

/**
 * Find out who is on the move (who has less tokens on the game board).
 */
function who_is_on_move($fields)
{
  $hist = [
    '' => 0,
    'X' => 0,
    'O' => 0,
  ];
  foreach ($fields as $field) ++$hist[$field];
  return $hist['X'] <= $hist['O'] ? 'X' : 'O';
}

$fields = [];
for ($index = 0; $index < 9; ++$index) {
  $fields[] = get_field_value($index);
}
$onMove = who_is_on_move($fields);

?>

<!DOCTYPE HTML>
<html lang="en">

<head>
  <title>PHP Examples - State in URL Query</title>
  <link rel="stylesheet" type="text/css" href="style.css">
</head>

<body>
  <h1>PHP Examples - State in URL Query</h1>
  <h2>Tic-Duck-Meow</h2>

  <table id="game">
    <?php render_game($fields, $onMove); ?>
  </table>

</body>

</html>
