#ifndef task6bitcount_hpp_
#define task6bitcount_hpp_

#include <cstddef>
#include <memory>
#include <vector>
#include <cassert>
#include <random>
#include <algorithm>
#include <iostream>

#include "testbed.hpp"

template< typename G, typename N>
inline void fill_array(G && g, N && n)
{
	for (std::size_t i = 0; i < n.size(); ++i)
	{
		n.set(i, g.get());
	}
}

template< typename N>
inline std::uint64_t chksum(N && n)
{
	std::uint64_t s = 0;
	for (std::size_t i = 0; i < n.size(); ++i)
	{
		s = 29 * s + n.get(i);
	}
	/*
	std::cout << std::endl << "*CHKSUM ";
	for (std::size_t i = 0; i < 64; ++i)
	{
		std::cout << (n.get(i) ? "1" : "0");
	}
	std::cout << " = " << s << "*" << std::endl;
	*/
	return s;
}

template< typename D, typename P>
struct generator_6 {

	typedef D data_type;
	typedef std::uint64_t check_type;	// a kind of checksum
		
	static std::string name() { return P::name() + "/" + D::name(); }

	/*
	std::string param() const 
	{ 
		return ulibpp::lexical_cast< std::string>( opsize_);
	}
	*/

	time_complexity complexity() const 
	{ 
		return opsize_;
	}

	check_type check() const
	{
		return 0;
	}

	const D & data() const
	{
		return d_;
	}

	template< typename GP>
	generator_6( const GP &, std::size_t opsize) 
		: opsize_( opsize),
		d_( opsize)
	{
		P gen;
		gen.reset();
		fill_array( gen, d_.a);
		fill_array( gen, d_.b);
	}

private:
	const std::size_t opsize_;
	D d_;
};

struct policy_zero {

	static std::string name() { return "zero"; }

	void reset()
	{
	}

	bool get()
	{
		return false;
	}
};

struct policy_one {

	static std::string name() { return "one"; }

	void reset()
	{
	}

	bool get()
	{
		return true;
	}
};

struct policy_random {

	static std::string name() { return "random"; }

	policy_random()
//		: distribution(0, 1)
	{
	}

	void reset()
	{
//		auto pre = engine();

		engine.seed(729);
//		distribution.reset();

//		auto post = engine();

		//std::cout << std::endl << "*MT reset " << pre << " -> " << post << "*" << std::endl;
	}

	bool get()
	{
//		return bool(distribution(engine) & 1);
		return bool(engine() & 1);
	}
private:
	std::mt19937 engine;
//	std::uniform_int_distribution<> distribution;
};

template< typename N, typename U>
struct data_6 {
public:

	static std::string name() {
		return U::name();
	}

	std::size_t byte_size() const
	{
//		return a.byte_size() + b.byte_size() + c.byte_size();
		return 0;
	}

	data_6( std::size_t size)
		: a(size), b(size), c(size), ccount(0)
	{
	}

	N a, b;
	mutable N c;
	mutable std::size_t ccount;
};

template< typename T>
struct task_6_common {

	template< bool debug, typename D, typename C>
	static void initial_check(logger & log, const D & data, const C & check)
	{
		log.ss() << "CHKSUM A[" << data.a.size() << "] = " << chksum(data.a) << std::endl;
		log.ss() << "CHKSUM B[" << data.b.size() << "] = " << chksum(data.b) << std::endl;
	}

	template< bool debug, typename D, typename C>
	static void final_check(logger & log, const D & data, const C & check)
	{
		log.ss() << "CHKSUM C[" << data.c.size() << "] = " << chksum(data.c) << std::endl;
		if (debug)
		{
			verify(log, data.c, data.a, data.b);
		}
	}

private:
	template< typename CT, typename AT, typename BT>
	static void verify(logger & log, const CT & c, const AT & a, const BT & b)
	{
		for (std::size_t i = 0; i < c.size(); ++i)
		{
			bool cc = T::expected( a.get(i), b.get(i));
			if (cc != c.get(i))
			{
				log.ss() << "VERIFY FAILED: C[" << i << "] = " << c.get(i) << " EXPECTED " << cc << std::endl;
				return;
			}
		}
		log.ss() << "VERIFIED." << std::endl;
	}
};

struct task_6_and : task_6_common< task_6_and> {

	static std::string name() { return "and"; }

	template< bool cold, bool debug, typename D, typename C>
	static void run(const D & data, const C & check)
	{
		data.c.assign_and(data.a, data.b);

		// assert( s == check);
	}

	static bool expected(bool a, bool b)
	{
		return a && b;
	}
};

struct task_6_or : task_6_common< task_6_or> {

	static std::string name() { return "or"; }

	template< bool cold, bool debug, typename D, typename C>
	static void run(const D & data, const C & check)
	{
		data.c.assign_or(data.a, data.b);

		// assert( s == check);
	}

	static bool expected(bool a, bool b)
	{
		return a || b;
	}
};

struct task_6_not : task_6_common< task_6_not> {

	static std::string name() { return "not"; }

	template< bool cold, bool debug, typename D, typename C>
	static void run(const D & data, const C & check)
	{
		data.c.assign_not(data.a);

		// assert( s == check);
	}

	static bool expected(bool a, bool)
	{
		return ! a;
	}
};

struct task_6_zero : task_6_common< task_6_zero> {

	static std::string name() { return "zero"; }

	template< bool cold, bool debug, typename D, typename C>
	static void run(const D & data, const C & check)
	{
		data.c.assign_zero();

		// assert( s == check);
	}

	static bool expected(bool, bool)
	{
		return false;
	}
};

struct task_6_count {

	static std::string name() { return "bitcount"; }

	template< bool cold, bool debug, typename D, typename C>
	static void run(const D & data, const C & check)
	{
		data.c.assign_and(data.a, data.b);

		data.ccount = data.c.count_ones();

		// assert( s == check);
	}

	template< bool debug, typename D, typename C>
	static void initial_check(logger & log, const D & data, const C & check)
	{
		log.ss() << "CHKSUM A[" << data.a.size() << "] = " << chksum(data.a) << std::endl;
		log.ss() << "CHKSUM B[" << data.b.size() << "] = " << chksum(data.b) << std::endl;
	}

	template< bool debug, typename D, typename C>
	static void final_check(logger & log, const D & data, const C & check)
	{
		log.ss() << "CHKSUM C[" << data.c.size() << "] = " << chksum(data.c) << std::endl;
		log.ss() << "COUNT C[" << data.c.size() << "] = " << data.ccount << std::endl;
		if (debug)
		{
			verify(log, data.ccount, data.a, data.b);
		}
	}

private:
	template< typename CT, typename AT, typename BT>
	static void verify(logger & log, const CT & ccount, const AT & a, const BT & b)
	{
		std::size_t s = 0;
		for (std::size_t i = 0; i < a.size(); ++i)
		{
			s += std::size_t(a.get(i) & b.get(i));
		}
		if (s != ccount)
		{
			log.ss() << "VERIFY FAILED: COUNT = " << ccount << " EXPECTED " << s << std::endl;
			return;
		}
		log.ss() << "VERIFIED." << std::endl;
	}
};

#endif

