#include "task6bitcount.hpp"

#include "testbed.hpp"

#include "du6bitcount.hpp"

#include <iostream>
#include <sstream>
#include <fstream>

///////////////////////////////
/*
struct use_64 {
	using policy = policy_64;
	static std::string name() { return "64"; }
};
*/

struct use_sse {
	using policy = policy_sse;
	static std::string name() { return "SSE"; }
};

struct use_avx {
	using policy = policy_avx;
	static std::string name() { return "AVX"; }
};

#ifdef USE_AVX512
struct use_avx512 {
	using policy = policy_avx512;
	static std::string name() { return "AVX512"; }
};
#endif

template< typename U>
void use( generator_list< std::size_t, time_complexity> & gl)
{
	using data = data_6< bitarray< typename U::policy>, U>;

	//gl.push_back(make_generic_generator_task< generator_6< data, policy_zero>, task_6_and, std::size_t>());
	gl.push_back(make_generic_generator_task< generator_6< data, policy_random>, task_6_and, std::size_t>());
	//gl.push_back(make_generic_generator_task< generator_6< data, policy_one>, task_6_and, std::size_t>());

	gl.push_back(make_generic_generator_task< generator_6< data, policy_random>, task_6_or, std::size_t>());
	gl.push_back(make_generic_generator_task< generator_6< data, policy_random>, task_6_not, std::size_t>());
	gl.push_back(make_generic_generator_task< generator_6< data, policy_random>, task_6_zero, std::size_t>());

	gl.push_back(make_generic_generator_task< generator_6< data, policy_zero>, task_6_count, std::size_t>());
	gl.push_back(make_generic_generator_task< generator_6< data, policy_random>, task_6_count, std::size_t>());
	gl.push_back(make_generic_generator_task< generator_6< data, policy_one>, task_6_count, std::size_t>());

}

int main(int argc, char * * argv)
{
	std::vector< std::string> arg(argv + 1, argv + argc);

	generator_list< std::size_t, time_complexity> gl;

#ifdef _DEBUG
	std::size_t min_elements = 1ULL * 1024ULL;
	std::size_t max_elements = 64ULL * 1024ULL;
	time_complexity target_complexity = 10000000UL;
#else
	std::size_t min_elements = 16ULL * 1024ULL;
	std::size_t max_elements = 32ULL * 1024ULL * 1024ULL;
	time_complexity target_complexity = 10000000000UL;
#endif

	bool u_avx = false, u_avx512 = false;

	if (arg.size() >= 1)
	{
		if (arg[0] == "avx")
			u_avx = true;
		if (arg[0] == "avx512")
		{
			u_avx = true;
			u_avx512 = true;
		}
	}

	//use<use_64>(gl);
#ifdef USE_AVX512
	if (u_avx512)
	{
		use<use_avx512>(gl);
	}
	else
#endif
	if (u_avx)
	{
		use<use_avx>(gl);
	}
	else
	{
		use<use_sse>(gl);
	}

	for ( std::size_t elements = min_elements - 23; elements <= max_elements; elements = 4 * elements + 77 )
	{
		gl.push_back_size( elements, target_complexity);
	}

	std::ostringstream serr;

	logger log( std::cout, serr);

#ifdef _DEBUG
	gl.run< true>( log);
#else
	gl.run< false>( log);
#endif

	std::cerr << serr.str();

	return 0;
}

///////////////////////////////
