#include "du1container.hpp"
#include "task1.hpp"

#include "testbed.hpp"

#include <algorithm>
#include <iostream>
#include <fstream>
#include <cassert>

///////////////////////////////

struct use_sse {
	using policy = policy_sse;
	static std::string name() { return "SSE"; }
};

#ifdef USE_AVX
struct use_avx {
	using policy = policy_avx;
	static std::string name() { return "AVX"; }
};
#endif

#ifdef USE_AVX512
struct use_avx512 {
	using policy = policy_avx512;
	static std::string name() { return "AVX512"; }
};
#endif

///////////////////////////////

template< template< typename ...> class C, typename U, bool use_variadic>
struct task_config;

template< template< typename ...> class C, typename U>
struct task_config< C, U, true>
{
	template< typename ... L>
	using data = C< typename U::policy, L ...>;
	using generator = generator_1_variadic< data, policy_random>;
};

template< template< typename ...> class C, typename U>
struct task_config< C, U, false>
{
	using data = C< typename U::policy>;
	using generator = generator_1< data, policy_random>;
};

#ifdef USE_VARIADIC
static const bool support_variadic = true;
#else
static const bool support_variadic = false;
#endif

template< typename U>
void use(generator_list< std::size_t, time_complexity> & gl)
{
	using generator = typename task_config< du1container, U, support_variadic>::generator;

	gl.push_back(make_generic_generator_task< generator, task_1, std::size_t>());
	gl.push_back(make_generic_generator_task< generator, task_1O, std::size_t>());
}

///////////////////////////////

int main( int argc, char * * argv)
{
	std::vector< std::string> arg{ argv + 1, argv + argc };

	generator_list< std::size_t, time_complexity> gl;

#ifdef _DEBUG
	time_complexity target_complexity = 500000UL;
	std::size_t min_elements = 64 * 1024;
	std::size_t max_elements = min_elements;
#else
	time_complexity target_complexity = 1000000000UL;
	std::size_t min_elements = 1024L;
	std::size_t max_elements = 64 * 1024UL * 1024UL;
//	std::size_t min_elements = 64 * 1024;
//	std::size_t max_elements = min_elements;
#endif

	bool u_avx = false, u_avx512 = false;

	if (arg.size() >= 1)
	{
		if (arg[0] == "avx")
			u_avx = true;
		if (arg[0] == "avx512")
		{
			u_avx = true;
			u_avx512 = true;
		}
	}

	//use<use_64>(gl);
#ifdef USE_AVX512
	if (u_avx512)
	{
		use<use_avx512>(gl);
	}
	else
#endif
#ifdef USE_AVX
		if (u_avx)
		{
			use<use_avx>(gl);
		}
		else
#endif
		{
			use<use_sse>(gl);
		}


	for ( std::size_t elements = min_elements; elements <= max_elements; elements <<= 3)
	{
		gl.push_back_size( elements, target_complexity);
	}

	logger log( std::cout, std::cerr);

#ifdef _DEBUG
	gl.run< true>( log);
#else
	gl.run< false>( log);
#endif

	return 0;
}

///////////////////////////////
